; CPU to VRAM test

        opt     l-
        icl     'atarihw.ah'
        icl     'atarios.ah'
        icl     'vbxefx.ah'
        opt     l+

;-------------------------------------------------------

ptr1    equ     0x90
ptr2    equ     0x92

        org     0x3000

Start

        lda     20
        cmp     20
        req
        lda     #0
        ;sta     DMACTLS
        ;sta     DMACTL

        lda     #0x90
        sta     MB_CPU
        ldy     #0
i1      lda     xdl,y
        sta     0x4000,y
        lda     0xe000,y
        sta     0x4800,y
        eor     #0xff
        sta     0x4c00,y
        lda     0xe100,y
        sta     0x4900,y
        eor     #0xff
        sta     0x4d00,y
        lda     0xe200,y
        sta     0x4a00,y
        eor     #0xff
        sta     0x4e00,y
        lda     0xe300,y
        sta     0x4b00,y
        eor     #0xff
        sta     0x4f00,y
        iny
        bne     i1

        lda     #0
        sta     XDL_ADR0
        sta     XDL_ADR1
        lda     #4
        sta     XDL_ADR2
        lda     #VC_XDL_ENABLED
        sta     VIDEO_CONTROL


l0      lda     RANDOM
        ;and     #0x1F
        and     #0x0F
        ora     #$80
        sta     MB_CPU

        lda     #0
        sta     COLBAKS
        sta     COLBAK

        mwa     #0x4000 ptr1
        mwa     #0x8000 ptr2

        ldy     #0

        ldx     #0x40
        ldx     #0x38
l1      lda     RANDOM
        sta     (ptr1),y
        sta     (ptr2),y
        iny
        bne     l1
        inc     ptr2+1
        inc     ptr1+1
        dex
        bne     l1

        mwa     #0x4000 ptr1
        mwa     #0x8000 ptr2

        lda     #0xc4
        sta     COLBAKS
        sta     COLBAK

        ldx     #0x40
        ldx     #0x38
l2      lda     (ptr1),y
        cmp     (ptr2),y
        bne     red
        iny
        bne     l2
        inc     ptr2+1
        inc     ptr1+1
        dex
        bne     l2
        jmp     l0

red     lda     #0x34
        sta     COLBAKS
        sta     COLBAK
        jmp     *


xdl
        .word   XDLC_RPTL
        .byte   23
        .word   XDLC_TMON+XDLC_CHBASE+XDLC_RPTL+XDLC_OVADR+XDLC_END
        .byte   191
        .long   0x50000
        .word   160
        .word   0x81




        run     Start

        end

